﻿using System;

namespace CSharpBuch.Kap05
{
  class Aufgabe5
  {
    static void Main(string[] args)
    {
      double summe = 0.0;
      WarenArtikel[] wa = { new WarenArtikel("Computer", 350.00),
                            new WarenArtikel("Maus", 20.00),
                            new WarenArtikel("Drucker", 99.00),
                            new WarenArtikel("30' FlatScreen", 3150.00) };

      BerechenBruttoUndRabatt(wa, ref summe);

      for (int i = 0; i < wa.Length; i++)
        Console.WriteLine("{0}, {1}, {2}, {3}",
                          wa[i].ArtikelName, wa[i].NettoPreis, wa[i].BruttoPreis, wa[i].RabattInProzent);

      Console.WriteLine("Summe aller Artikel ist: {0}", summe);
    }

    static void BerechenBruttoUndRabatt(WarenArtikel[] was, ref double summe)
    {
      for (int i = 0; i < was.Length; i++)
      {
        was[i].BruttoPreis = was[i].NettoPreis * 1.19;
        if (was[i].BruttoPreis > 100.0)
          was[i].RabattInProzent = 3;
        else
          was[i].RabattInProzent = 0;

        summe = summe + was[i].BruttoPreis - (was[i].BruttoPreis / 100 * was[i].RabattInProzent);
      }
    }
  }

  public struct WarenArtikel
  {
    public WarenArtikel(string artikelName, double nettePreis)
    {
      ArtikelName = artikelName;
      NettoPreis = nettePreis;
      BruttoPreis = 0.0;
      RabattInProzent = 0;
    }
    public string ArtikelName;
    public double NettoPreis;
    public double BruttoPreis;
    public int RabattInProzent;
  }
}